# Verify that X is numeric, and convert to a matrix in case it is just a
# vector.
validate_X <- function(X, verbose){
  if(!is.null(X)){
    if(!is.matrix(X)){
      if(isTRUE(verbose)) message("Coercing X to matrix...")
      X <- tryCatch(as.matrix(X), error = function(e) stop("Error converting X to a matrix: ", e))
    }
    validate_numeric(x = X, message = "X failed numeric validation: ")
    column_value_counts <- apply(X, MARGIN = 2, function(x) length(unique(x)))
    if(!identical(colnames(X)[1], "(Intercept)") && isTRUE(any(column_value_counts == 1)))
      warning("At least one column of X contains only one value. Verify that the model is identifiable.")
    return(X)
  }
}
