calc_mu <-
function(J, solve_tol, orth_tol){
  stopifnot(is.matrix(J), is.numeric(J), is.numeric(solve_tol),
            length(solve_tol) == 1, solve_tol > 0)
  nR <- crossprod(J)
  nR_sqrt <- tryCatch(t(chol(nR)),
                      error = function(e) stop("Unable to calculate Cholesky decomposition of t(J) %*% J: ", e))
  mu <- tryCatch(t(solve(nR_sqrt, t(J), tol = solve_tol)),
                 error = function(e) stop("Unable to solve system to calculate mu: ", e))
  stopifnot("crossprod(mu) is not equal to the identity matrix" =
              isTRUE(all.equal(crossprod(mu), diag(ncol(mu)),
                               check.attributes = FALSE,
                               tolerance = orth_tol)))
  return(mu)
}
