% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_afc_utils.R
\name{e_afccol}
\alias{e_afccol}
\title{AFC plot of variables}
\usage{
e_afccol(
  modelo,
  axes = c(1, 2),
  colorCol = "forestgreen",
  cos2 = 0,
  colorCos = "darkorchid",
  titulos = c("Bien Representados", "Mal Representados")
)
}
\arguments{
\item{modelo}{an object of class CA [FactoMineR].}

\item{axes}{a numeric vector of length 2 specifying the dimensions to be plotted.}

\item{colorCol}{a color for the variables well represented.}

\item{cos2}{a numeric value from 0 to 1 specifying the quality of the variables.}

\item{colorCos}{a color for the variables badly represented.}

\item{titulos}{a character vector of length 2 specifying the titles to use on legend.}
}
\value{
echarts4r plot
}
\description{
AFC plot of variables
}
\examples{
p <- FactoMineR::CA(iris[, -5], graph = FALSE)
e_afccol(p)

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
