% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animations.R
\name{animate_scalp}
\alias{animate_scalp}
\title{3D scalp plot animation in time}
\usage{
animate_scalp(
  data,
  amplitude,
  mesh,
  tri,
  coords = NULL,
  template = NULL,
  col_range = NULL,
  col_scale = NULL,
  sec = 0.3,
  frames_dir = NULL,
  output_path = NULL,
  framerate = 3,
  cleanup = TRUE
)
}
\arguments{
\item{data}{An input data frame or tibble with at least this required columns: \code{time} - the number of time point, \code{sensor} - the sensor label and the column with the EEG amplitude to plot specified in the argument \code{amplitude}.}

\item{amplitude}{A character string naming the column with EEG amplitude values.}

\item{mesh}{An object of class \code{"mesh"} (or a named list with the same structure) used for computing IM model. If not defined, the polygon point mesh with default settings from \code{\link{point_mesh}} function is used. See \code{\link{scalp_plot}} for details about the structure.}

\item{tri}{A matrix with indices of the triangles. If missing, the triangulation is computed using \code{\link{make_triangulation}} function from \code{D2} element of the mesh.}

\item{coords}{Sensor coordinates as a tibble or data frame with named \code{x}, \code{y} and \code{z} columns of sensor coordinates and \code{sensor} column with sensor names. If not defined, the HCGSN256 template is used.}

\item{template}{The kind of sensor template montage used. Currently the only available option is \code{"HCGSN256"} denoting the 256-channel HydroCel Geodesic Sensor Net v.1.0, which is also a default setting.}

\item{col_range}{A vector with minimum and maximum value of the amplitude used in the colour palette for plotting. If not defined, the range of interpolated signal is used.}

\item{col_scale}{Optionally, a colour scale to be utilised for plotting. If not defined, it is computed from \code{col_range}.}

\item{sec}{The time interval used between individual animation frames, in seconds (default: 0.3).}

\item{frames_dir}{Directory where the individual frames will be saved. If NULL, the video is only displayed in viewer and the frames are not saved.}

\item{output_path}{Optional path to the output mp4 video file (".mp4" extension is required for correct rendering). If NULL, no video is created.}

\item{framerate}{Number of frames per second for the output mp4 video (default: 3).}

\item{cleanup}{Logical. Indicates, if all the PNG files should be deleted after encoding video. Default value is \code{TRUE}.}
}
\value{
The output depends on the provided arguments:
\itemize{
\item If \code{frames_dir} is specified, individual animation frames (PNG) are saved to that directory.
\item If also \code{output_path} is specified, a video (MP4) is created and saved using the \code{av} package.
\item Otherwise, the animation is displayed in an interactive rgl window.
}
}
\description{
Display a topographic 3D scalp animation of the change in amplitude over time. The function enables direct rendering in Rstudio Viewer or saving the animation in MP4 format or individual frames in PNG format to the chosen location.
}
\details{
Setting the parameter \code{tri} requires defining a \code{mesh} parameter.
The parameter \code{mesh} should optimally be a \code{"mesh"} object (output from \code{\link{point_mesh}} function) or a list with the same structure (see \code{\link{point_mesh}} for more information). In that case, setting the argument \code{tri} is optional, and if it is absent, a triangulation based on the \code{D2} element of the mesh is calculated and used in the plot.
If the input \code{mesh} contains only 3D coordinates of a point mesh in \code{D3} element, the use of previously created triangulation (through \code{tri} argument) is required.

Notes:
For exporting the video, setting \code{frames_dir} together with \code{output_path} is required.

When specifying the \code{coords} and \code{template} at the same time, the \code{template} parameter takes precedence and the \code{coords} parameter is ignored.
}
\examples{
\donttest{
# This example may take a few seconds to render.
# Run only if you want to generate the full animation.
# Note: The example opens a rgl 3D viewer.
# Prepare a data structure:
s1e05 <- pick_data(epochdata, subject_rg = 1, epoch_rg = 5, time_rg = 10:20)
# Plot animation with default mesh and triangulation:
animate_scalp(s1e05, amplitude = "signal")
}
}
\seealso{
Static version: \code{\link{scalp_plot}}, animated 2D topo map: \code{\link{animate_topo}}
}
