% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoodCD.R
\name{likelihoodCD}
\alias{likelihoodCD}
\title{Calculate Conditional Likelihood Displacement}
\usage{
likelihoodCD(model)
}
\arguments{
\item{model}{Object returned from regL1 representing the fit of the L1 model.}
}
\value{
\item{Likelihood Displacement}{          A vector with Likelihood Displacement for each observation.}.
}
\description{
Calculate Conditional Likelihood Displacement
}
\examples{
set.seed(123)
x = matrix(rnorm(100), ncol = 2)
y = x[, 1] + x[, 2] + rlaplace(50, 0, 5)

# Fits a linear regression L1 model
mod1 = regL1(y ~ x)
likelihoodCD(mod1)
}
\references{
Elian, S. N., André, C. D. S. and Narula, S. C. (2000). Influence Measure for the
\ifelse{html}{\out{L<sub>1</sub>}}{\eqn{L1}} regression.
\emph{Communications in Statistics - Theory and Methods}, \strong{29}(4), 837-849. \doi{10.1080/03610920008832518}.
}
