% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{window}
\alias{window}
\title{Trim the sequence of hyperparameter estimates within a DGP emulator}
\usage{
window(object, start, end = NULL, thin = 1)
}
\arguments{
\item{object}{an instance of the S3 class \code{dgp}.}

\item{start}{the first iteration before which all iterations are trimmed from the sequence.}

\item{end}{the last iteration after which all iterations are trimmed from the sequence.
Set to \code{NULL} to keep all iterations after (including) \code{start}. Defaults to \code{NULL}.}

\item{thin}{the interval between the \code{start} and \code{end} iterations to thin out the sequence.
Defaults to 1.}
}
\value{
An updated \code{object} with a trimmed sequence of hyperparameters.
}
\description{
This function trims the sequence of hyperparameter estimates within a DGP emulator
generated during training.
}
\details{
See further examples and tutorials at \url{https://mingdeyu.github.io/dgpsi-R/}.
}
\note{
\itemize{
\item This function is useful when a DGP emulator has been trained and one wants to trim
the sequence of hyperparameters estimated and to use the trimmed sequence to generate point estimates
of the DGP model parameters for prediction.
\item The following slots:
\itemize{
\item \code{loo} and \code{oos} created by \code{\link[=validate]{validate()}}; and
\item \code{results} created by \code{\link[=predict]{predict()}}
in \code{object} will be removed and not contained in the returned object.
}
}
}
\examples{
\dontrun{

# See dgp() for an example.
}
}
