% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{draw}
\alias{draw}
\alias{draw.gp}
\alias{draw.dgp}
\alias{draw.bundle}
\title{Validation and diagnostic plots for a sequential design}
\usage{
draw(object, ...)

\method{draw}{gp}(object, type = "rmse", log = FALSE, ...)

\method{draw}{dgp}(object, type = "rmse", log = FALSE, ...)

\method{draw}{bundle}(object, type = "rmse", log = FALSE, emulator = NULL, ...)
}
\arguments{
\item{object}{can be one of the following emulator classes:
\itemize{
\item the S3 class \code{gp}.
\item the S3 class \code{dgp}.
\item the S3 class \code{bundle}.
}}

\item{...}{N/A.}

\item{type}{specifies the type of plot or visualization to generate:
\itemize{
\item \code{"rmse"}: generates a trace plot of RMSEs, log-losses for DGP emulators with categorical likelihoods, or custom evaluation metrics specified via the \code{"eval"} argument in the \verb{[design()]} function.
\item \code{"design"}: shows visualizations of input designs created by the sequential design procedure.
}

Defaults to \code{"rmse"}.}

\item{log}{a bool indicating whether to plot RMSEs, log-losses (for DGP emulators with categorical likelihoods), or custom evaluation metrics on a log scale when \code{type = "rmse"}.
Defaults to \code{FALSE}.}

\item{emulator}{an index or vector of indices of emulators packed in \code{object}. This argument is only used if \code{object} is an instance of the \code{bundle} class. When set to \code{NULL}, all
emulators in the bundle are drawn. Defaults to \code{NULL}.}
}
\value{
A \code{patchwork} object.
}
\description{
This function draws diagnostic and validation plots for a sequential design of a (D)GP emulator or a bundle of (D)GP emulators.
}
\details{
See further examples and tutorials at \url{https://mingdeyu.github.io/dgpsi-R/}.
}
\examples{
\dontrun{

# See design() for an example.
}
}
