% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_helpers.R
\name{wrapQuote}
\alias{wrapQuote}
\title{wrap all elements in a vector in quotes (or other strings)}
\usage{
wrapQuote(v, quoteChr = "'", endquoteChr = NULL)
}
\arguments{
\item{v}{vector of elements to wrap}

\item{quoteChr}{character.  to be put around of the elements of
\code{v}.  Defaults to "'".}

\item{endquoteChr}{character or NULL (default).  If not NULL
\code{quoteChr} is put before the elements of \code{v} and
\code{endquoteChr} is put after them}
}
\value{
character vector of the elements of \code{v} wrapped
  between quotes
}
\description{
wrap all elements in a vector in quotes (or other strings)
}
\examples{
## default behaviour: wrap in single quotes
wrapQuote(1:10)

## change to wrap in asterisks
wrapQuote(1:10, "*")

## different front from back quotes
wrapQuote(1:10, "*", "/")

## you can also wrap with longer strings
wrapQuote(1:10, "quote")
}
\author{
Andreas Leha
}
