% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{w.ggbetweenstats}
\alias{w.ggbetweenstats}
\title{Wrapper for ggstatsplot::ggbetweenstats with optional p-value annotation and date formatting}
\usage{
w.ggbetweenstats(
  data,
  parameter,
  groupby = NULL,
  pval.display = FALSE,
  ldat,
  ...
)
}
\arguments{
\item{data}{A data frame with the data to be plotted.}

\item{parameter}{Character. Name of the column in \code{data} to the values to be plotted.}

\item{groupby}{Character (default: NULL). Name of the grouping (categorical) variable in \code{data}.}

\item{pval.display}{Logical. If \code{TRUE} and there are exactly two groups in \code{groupby}, a p-value annotation is added.}

\item{ldat}{A data frame containing the p-value(s) to annotate on the plot. Expected columns: `"p value"` and/or `"adjusted p value"`.}

\item{...}{Additional arguments passed to \code{\link[ggstatsplot]{ggbetweenstats}}.}
}
\value{
A \code{ggplot} object.
}
\description{
This function creates a `ggbetweenstats` plot from `ggstatsplot`, and optionally adds a p-value annotation using `geom_signif` for two-group comparisons based on values in `ldat`.
If requested, it can also format the y-axis as dates.
}
\details{
If \code{groupby} is not \code{NULL} and there are exactly two levels in the grouping variable, and \code{pval.display = TRUE}, a p-value from \code{ldat} is added between the two groups using \code{geom_signif}. If \code{"adjusted p value"} is present in \code{ldat}, it is used; otherwise, \code{"p value"} is used. If \code{wasDate} is \code{TRUE}, the y-axis labels are formatted as dates.
}
\examples{
## ungrouped plot
p <- w.ggbetweenstats(iris, "Sepal.Length")
if (FALSE) print(p)

## grouped plot
p <- w.ggbetweenstats(iris, "Sepal.Length", groupby = "Species",
                      bf.message = FALSE, pairwise.display = "none")
if (FALSE) print(p)

## grouped plot with p value annotation for >2 groups
pval <- anova(lm(Sepal.Length ~ Species, data = iris))['Species', 'Pr(>F)']
pval <- descutils::prettyPvalues(pval, digits = 3, orgbold = FALSE, lhs = "p")
ldat <- data.frame(`p value` = pval, check.names = FALSE)
p <- w.ggbetweenstats(iris, "Sepal.Length", groupby = "Species", pval.display = TRUE, ldat = ldat,
                      bf.message = FALSE, pairwise.display = "none")
if (FALSE) print(p)

## setup simple data with only two groups
iris2 <- iris[iris$Species \%in\% c("setosa", "virginica"),]

## grouped plot with p value annotation for two groups
pval <- t.test(Sepal.Length ~ Species, data = iris2)$p.value
pval <- descutils::prettyPvalues(pval, digits = 3, orgbold = FALSE, lhs = "p")
ldat <- data.frame(`p value` = pval, check.names = FALSE)
p <- w.ggbetweenstats(iris2, "Sepal.Length", groupby = "Species", pval.display = TRUE, ldat = ldat,
                      bf.message = FALSE, pairwise.display = "none")
if (FALSE) print(p)
}
\author{
Fabian Kück
}
