% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QRdepcens.R
\name{QRdepCens}
\alias{QRdepCens}
\title{Estimate the model of D'Haen et al. (2025).}
\usage{
QRdepCens(data, hp, var.estimate = FALSE, verbose = TRUE)
}
\arguments{
\item{data}{Data on which the model should be estimated. Note that the data
should be structured in a specific form: The observed times should be put in
a column named \code{"Y"}, the censoring indicators in a column named
\code{"Delta"}, and the covariates in columns named \code{"X1"}, \code{"X2"},
... (in increasing order). The given data set cannot contain any other
columns.}

\item{hp}{List of hyperparameters to be used, the elements of which will
overwrite the default settings. In particular, consider changing:
\describe{
 \item{test_cop_name:}{Copula to be used. Should be one of
 \code{"frank"}, \code{"gumbel"}, \code{"clayton"} or \code{"indep"}.}
 \item{homoscedastic:}{Boolean flag indicating whether
 homoscedasticity can be assumed.}
 \item{variance.bootstrap.iterations:}{Number of bootstrap resamples
 to use during variance estimation. Consider increase if more precision is
 needed; consider decreasing to reduce computation time.}
}
Other hyperparameters can be changed though it is not recommended. We refer
to the source code for the available options.}

\item{var.estimate}{Boolean value indicating whether the variance should be
estimated (via bootstrap). This can take a considerable amount of time.
Default is \code{var.estimate = FALSE}.}

\item{verbose}{Verbosity flag (boolean) indicating whether the results should
be printed to the console. Default is \code{verbose = TRUE}.}
}
\description{
This function estimates the parameters in the model of D'Haen et al. (2025).
}
\note{
The variance estimation procedure could easily be paralelized.
However, this is currently not implemented.
}
\examples{
\donttest{

 # Load the data
 data(liver)

 # Give standard column names (required!)
 colnames(liver) <- c("patient", "Y", "Delta", "X1", "X2", "X3", "X4")
 liver <- liver[, c(-1, -6, -7)]

 # Run the model
 hp <- list(
   homoscedastic = FALSE,
   test_cop_name = "frank"
 )
 QRdepCens(liver, hp, var.estimate = FALSE)
 # Takes a while if var.estimate = TRUE...
}

}
\references{
D'Haen, M., Van Keilegom, I. and Verhasselt, A. (2025). Quantile
regression under dependent censoring with unknown association. Lifetime Data
Analysis 31(2):253-299.
}
