% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratified.R
\name{sum_stat_p_strata}
\alias{sum_stat_p_strata}
\title{Summarize Variables with Optional Stratification and Statistical Tests}
\usage{
sum_stat_p_strata(
  data,
  by,
  strata = NULL,
  statistic = "mean_sd",
  test_type = "auto",
  paired = FALSE
)
}
\arguments{
\item{data}{A data frame containing the variables to summarize.}

\item{by}{The main grouping variable for comparison.}

\item{strata}{Optional stratification variable. Summaries are produced within each stratum.}

\item{statistic}{Statistic to report for numeric variables: \code{"mean_sd"} (default) or \code{"med_iqr"}.}

\item{test_type}{Statistical test to use. Options: \code{"auto"} (default, selects appropriate test),
\code{"t.test"}, \code{"wilcox"}, \code{"anova"}, \code{"kruskal"}, \code{"fisher"}, or \code{"chisq"}.}

\item{paired}{Logical. If TRUE, paired t-tests are used when applicable (default: FALSE).}
}
\value{
A \code{flextable} object containing the summary table with optional p-values,
counts, percentages, and numeric summaries. Footnotes describe the statistics used and tests performed.
}
\description{
Produces summary tables for numeric and categorical variables in a dataset,
optionally stratified by a grouping variable. Numeric variables are summarized
with mean (SD) or median (IQR), and categorical variables with counts and percentages.
Appropriate statistical tests (t-test, Wilcoxon, ANOVA, Kruskal-Wallis, Chi-square, or Fisher's Exact)
are performed depending on the variable type, number of groups, and user-specified options.
}
\examples{
# Example : Summary of CO2 dataset by Type, stratified by Treatment
sum_stat_p_strata(data = CO2, by = "Type", strata = "Treatment")

}
