% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_hoc.R
\name{sum_posthoc}
\alias{sum_posthoc}
\title{Summarize Variables with Post-hoc Tests: Mutiple comparisons}
\usage{
sum_posthoc(
  data,
  by,
  variables = NULL,
  digits = 2,
  format_lt = "<0.001",
  na.rm = TRUE,
  statistic = "auto",
  test_type = "auto"
)
}
\arguments{
\item{data}{A data frame containing the variables to summarize.}

\item{by}{The grouping variable for comparisons (factor or character).}

\item{variables}{A character vector of variable names to summarize. If NULL, all variables except \code{by} are used.}

\item{digits}{Number of decimal places for numeric summaries (default: 2).}

\item{format_lt}{Character string to display very small p-values, e.g., "<0.001" (default: "<0.001").}

\item{na.rm}{Logical. If TRUE, removes missing values before computations (default: TRUE).}

\item{statistic}{Summary statistic for numeric variables. Options: "auto" (default), "mean_sd", "med_iqr".}

\item{test_type}{Global test type. Options: "auto" (default), "anova", "kruskal".}
}
\value{
A \code{flextable} containing the summary table, global p-values, and post-hoc results.
}
\description{
Produces a summary table of numeric or categorical variables grouped by a factor,
optionally performing global tests (ANOVA or Kruskal-Wallis) and post-hoc comparisons
(Tukey or Dunn test). Numeric variables can be summarized using mean (SD) or median (IQR).
Returns a \code{flextable} suitable for reporting.
}
\examples{
sum_posthoc(
  data = iris,
  by = "Species",
  variables = c("Sepal.Length","Sepal.Width","Petal.Length","Petal.Width"),
  digits = 2,
  statistic = "auto",
  test_type = "auto"
)
}
