#' @keywords internal

compute_b_w_ratio <- function(D, group_sizes, weights = density.weights) {
  n <- sum(group_sizes)
  k <- length(group_sizes)

  G <- matrix(0, nrow = n, ncol = k)
  start_idx <- 1
  for (i in seq_along(group_sizes)) {
    end_idx <- start_idx + group_sizes[i] - 1
    G[start_idx:end_idx, i] <- 1
    start_idx <- end_idx + 1
  }

  W_D <- diag(weights)

  n_w <- colSums(G * weights)
  N_w <- diag(n_w)

  F_w <- solve(N_w) %*% t(G) %*% W_D %*% D %*% W_D %*% G %*% solve(N_w)

  DB_w <- matrix(0, nrow = k, ncol = k)
  for (r in 1:k) {
    for (s in 1:k) {
      DB_w[r, s] <- (2 * F_w[r, s] - F_w[r, r] - F_w[s, s]) / 2
    }
  }

  B_w <- (1 / sum(weights)) * t(n_w) %*% DB_w %*% n_w

  return(as.numeric(B_w))
}
