#' @keywords internal

calculate_distances_expectation <- function(groups, x) {
  combined_group <- do.call(rbind, groups)
  expectations <- apply(combined_group, 1, function(row) {
    compute_expectation(x, row)
  })
  n <- length(expectations)
  D <- matrix(0, n, n)
  for (i in 1:n) {
    for (j in i:n) {
      diff <- abs(expectations[i] - expectations[j])
      D[i, j] <- diff^2 / 2
      D[j, i] <- D[i, j]
    }
  }
  return(D)
}

calculate_distances_variance <- function(groups, x) {
  combined_group <- do.call(rbind, groups)
  variances <- apply(combined_group, 1, function(row) {
    compute_variance(x, row)
  })
  n <- length(variances)
  D <- matrix(0, n, n)
  for (i in 1:n) {
    for (j in i:n) {
      diff <- abs(log(variances[i] / variances[j]))
      D[i, j] <- diff^2 / 2
      D[j, i] <- D[i, j]
    }
  }
  return(D)
}

calculate_distances_skewness <- function(groups, x) {
  combined_group <- do.call(rbind, groups)
  skewnesses <- apply(combined_group, 1, function(row) {
    compute_skewness(x, row)
  })
  n <- length(skewnesses)
  D <- matrix(0, n, n)
  for (i in 1:n) {
    for (j in i:n) {
      diff <- abs(skewnesses[i] - skewnesses[j])
      D[i, j] <- diff^2 / 2
      D[j, i] <- D[i, j]
    }
  }
  return(D)
}

calculate_distances_kurtosis <- function(groups, x) {
  combined_group <- do.call(rbind, groups)
  kurtosis <- apply(combined_group, 1, function(row) {
    compute_kurtosis(x, row)
  })
  n <- length(kurtosis)
  D <- matrix(0, n, n)
  for (i in 1:n) {
    for (j in i:n) {
      diff <- abs(log(kurtosis[i] / kurtosis[j]))
      D[i, j] <- diff^2 / 2
      D[j, i] <- D[i, j]
    }
  }
  return(D)
}
