% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{simulate.deform}
\alias{simulate.deform}
\title{Simulate from a fitted \code{deform} object}
\usage{
\method{simulate}{deform}(object, nsim = 1, seed = NULL, newdata = NULL, ...)
}
\arguments{
\item{object}{a fitted \code{deform} object}

\item{nsim}{an integer giving the number of simulations}

\item{seed}{an integer giving the seed for simulations}

\item{newdata}{a 2-column matrix of x and y coordinates}

\item{...}{extra arguments to pass to \code{predict.deform()}}
}
\value{
Plots representing all one- or two-dimensional smooths
}
\description{
Simulate from a fitted \code{deform} object
}
\examples{

\donttest{

# deformations
data(solar)
m0 <- deform(solar$x, solar$z, solar$n) 
# Gaussian process simulations based on fitted deformation model
simulate(m0)

}

# one-dimensional expansion model with five simulations and specified locations
data(solar)
m1 <- expand(solar$x, solar$z, solar$n)
xvals <- seq(-123.3, -122.25, by = .05)
yvals <- seq(49, 49.4, by = .05)
xyvals <- expand.grid(xvals, yvals)
simulate(m1, 5, newdata = xyvals)

}
