% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{cencov}
\alias{cencov}
\alias{cencor}
\title{Correlation and covariance matrices from censored data}
\usage{
cencov(x, u)

cencor(x, u)
}
\arguments{
\item{x}{a numeric matrix}

\item{u}{a numeric matrix giving corresponding points of left-censoring}
}
\value{
a matrix
}
\description{
Correlation and covariance matrices from censored data
}
\details{
For \code{cencov()} a covariance matrix is returned and for 
\code{cencor()} a correlation matrix is returned. Note that \code{cencov()} 
calls \code{cencor()}. Estimates are based on assuming values are from a 
multivariate Gaussian distribution.
}
\examples{

# generate some correlated data
n <- 1e2
x <- rnorm(n)
y <- 0.25 * x + sqrt(0.75) * rnorm(n)
xy <- cbind(x, y)
# threshold of zero for left-censoring
u <- matrix(0, n, 2) 
# left-censored correlation matrix
cencor(xy, u) # could check with cor(xy)
# left-censored covariance matrix
cencov(xy, u)

}
\seealso{
\link{cov} and \link{cor} for uncensored estimates.
}
