#' @importFrom Rlibeemd emd_num_imfs eemd
#' @importFrom forecast auto.arima
#' @importFrom utils head tail
#' @importFrom graphics plot
#' @importFrom stats as.ts ts
#' @export
#'

eemdARIMA <- function (data, stepahead = 10, num.IMFs = emd_num_imfs(length(data)),
                       s.num = 4L, num.sift = 50L, ensem.size = 250L, noise.st = 0.2)
{
  n.IMF <- num.IMFs
  AllIMF <- eemd(ts(data), num_imfs = n.IMF, ensemble_size = ensem.size,
                 noise_strength = noise.st, S_number = s.num, num_siftings = num.sift,
                 rng_seed = 0L, threads = 0L)
  data_trn <- ts(head(data, round(length(data) - stepahead)))
  data_test <- ts(tail(data, stepahead))
  IMF_trn <- AllIMF[-c(((length(data) - stepahead) + 1):length(data)),
  ]
  Fcast_AllIMF <- NULL
  for (IMF in 1:ncol(IMF_trn)) {
    IndIMF <- NULL
    IndIMF <- IMF_trn[, IMF]
    eemdARIMAFit <- forecast::auto.arima(as.ts(IndIMF))
    eemdARIMA_fcast = forecast::forecast(eemdARIMAFit, h = stepahead)
    eemdARIMA_fcast_Mean = eemdARIMA_fcast$mean
    Fcast_AllIMF <- cbind(Fcast_AllIMF, as.matrix(eemdARIMA_fcast_Mean))
  }
  FinaleemdARIMA_fcast <- ts(rowSums(Fcast_AllIMF, na.rm = T))
  MAE_eemdARIMA = mean(abs(data_test - FinaleemdARIMA_fcast))
  MAPE_eemdARIMA = mean(abs(data_test - FinaleemdARIMA_fcast)/data_test)
  RMSE_eemdARIMA = sqrt(mean((data_test - FinaleemdARIMA_fcast)^2))
  Plot_IMFs <- AllIMF
  AllIMF_plots <- plot(Plot_IMFs)
  return(list(TotalIMF = n.IMF, AllIMF = AllIMF, AllIMF_plots = AllIMF_plots, data_test = data_test, AllIMF_forecast = Fcast_AllIMF,
              FinaleemdARIMA_forecast = FinaleemdARIMA_fcast, MAE_eemdARIMA = MAE_eemdARIMA,
              MAPE_eemdARIMA = MAPE_eemdARIMA, RMSE_eemdARIMA = RMSE_eemdARIMA))
}


