% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outcome_models.R
\name{get_OR_matching}
\alias{get_OR_matching}
\alias{get_RR_matching}
\alias{get_HR_matching}
\alias{get_OR_stratification}
\alias{get_RR_stratification}
\alias{get_HR_stratification}
\alias{get_OR_weighting}
\alias{get_RR_weighting}
\alias{get_HR_weighting}
\title{Estimate Odds Ratio (OR) after Propensity Score Matching}
\usage{
get_OR_matching(data, names_outcome)

get_RR_matching(data, names_outcome)

get_HR_matching(data, names_outcome)

get_OR_stratification(data, names_outcome)

get_RR_stratification(data, names_outcome)

get_HR_stratification(data, names_outcome)

get_OR_weighting(data, names_outcome, IPTW)

get_RR_weighting(data, names_outcome, IPTW)

get_HR_weighting(data, names_outcome, IPTW)
}
\arguments{
\item{data}{A dataset containing treatment assignment and outcome variables.}

\item{names_outcome}{A character vector of outcome variable names.}

\item{IPTW}{A numeric vector of inverse probability of treatment weights.}
}
\value{
A data frame with the estimated log odds ratio, standard error, and p-value.
}
\description{
Computes the odds ratio for a binary outcome after applying propensity score matching.

Computes the risk ratio for a binary outcome after applying propensity score matching.

Computes the hazard ratio for a time-to-event outcome after propensity score matching.

Computes OR, RR, and HR for a binary or time-to-event outcome after stratification.

Computes the risk ratio for a binary outcome after applying propensity score stratification.

Computes the hazard ratio for a time-to-event outcome after propensity score stratification.

Computes the odds ratio for a binary outcome after applying propensity score weighting.

Computes the risk ratio for a binary outcome after applying propensity score weighting.

Computes the hazard ratio for a time-to-event outcome after applying propensity score weighting.
}
