% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{Data_MC_contamination}
\alias{Data_MC_contamination}
\title{Moderate-correlation dataset with contamination}
\format{
A data frame with 525 rows and 10 variables:
\describe{
  \item{V1}{Continuous variable 1}
  \item{V2}{Continuous variable 2}
  \item{V3}{Continuous variable 3}
  \item{V4}{Continuous variable 4}
  \item{V5}{Categorical variable 1 (3 categories, approx. balanced)}
  \item{V6}{Categorical variable 2 (3 categories, approx. balanced)}
  \item{V7}{Categorical variable 3 (4 categories, uniform distribution)}
  \item{V8}{Binary variable 1 (40\% zeros, 60\% ones)}
  \item{V9}{Binary variable 2 (60\% zeros, 40\% ones)}
  \item{w_loop}{Observation weights derived from the joint distribution of
  V5 and V8, following a proportional frequency-based scheme.}
}
}
\usage{
Data_MC_contamination
}
\description{
Synthetic dataset generated from a multivariate normal distribution with
moderate correlation structure (\eqn{\rho = 0.6}). It contains 525 observations
and 10 variables of mixed type (continuous, categorical, binary, and weights).
The last 25 rows correspond to contaminated observations created by adding
perturbations equal to three times the standard deviation of each quantitative
variable to a subset of original units. This results in a controlled 5\%
contamination level. These data follow the design in
\insertCite{boj2024robustification}{dbrobust}.
}
\details{
\itemize{
 \item Continuous variables were drawn directly from the multivariate normal sample.
 \item Binary and categorical variables were obtained by discretizing normal margins
  using percentile-based thresholds.
 \item Contaminated observations (rows 501–525) were generated by perturbing
  original cases with fluctuations of 3 SD.
 \item The weighting scheme prioritizes frequent category combinations.
}
}
\references{
\insertRef{boj2024robustification}{dbrobust}
}
\keyword{datasets}
