% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_temp_vars.R
\name{drop_temp_vars}
\alias{drop_temp_vars}
\title{Drops Temporary Variables From a Dataset}
\usage{
drop_temp_vars(dsin, drop_dcut_temp = TRUE)
}
\arguments{
\item{dsin}{Name of input dataframe}

\item{drop_dcut_temp}{Whether or not to drop variables beginning with DCUT_TEMP_ (TRUE/FALSE).}
}
\value{
Returns the input dataframe, excluding the temporary variables.
}
\description{
Drops all the temporary variables (variables beginning with TEMP_) from the input
dataset. Also allows the user to specify whether or not to drop the temporary variables needed
throughout multiple steps of the datacut process (variables beginning with DCUT_TEMP_).
}
\details{
The other functions within this package use \code{drop_temp_vars} with the \code{drop_dcut_temp}
argument set to FALSE so that the variables needed across multiple steps of the process are
kept. The final datacut takes place in the \code{apply_cut} function, at which point \code{drop_temp_vars}
is used with the \code{drop_dcut_temp} argument set to TRUE, so that all temporary variables are
dropped.
}
\examples{
ae <- tibble::tribble(
  ~USUBJID, ~AESEQ, ~TEMP_FLAG, ~DCUT_TEMP_REMOVE,
  "subject1", 1, "Y", NA,
  "subject1", 2, "Y", NA,
  "subject1", 3, NA, "Y",
  "subject2", 2, "Y", NA,
  "subject3", 1, NA, "Y",
  "subject4", 1, NA, "Y"
)
drop_temp_vars(dsin = ae) # Drops temp_ and dcut_temp_ variables
drop_temp_vars(dsin = ae, drop_dcut_temp = TRUE) # Drops temp_ and dcut_temp_ variables
drop_temp_vars(dsin = ae, drop_dcut_temp = FALSE) # Drops temp_ variables

}
\keyword{user_utility}
