% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{dc_get_statistical_variables}
\alias{dc_get_statistical_variables}
\title{Get Available Statistical Variables from Data Commons}
\usage{
dc_get_statistical_variables(
  api_key = Sys.getenv("DATACOMMONS_API_KEY"),
  base_url = Sys.getenv("DATACOMMONS_BASE_URL", unset =
    "https://api.datacommons.org/v2/"),
  return_type = "json"
)
}
\arguments{
\item{api_key}{Your Data Commons API key. If not provided, will use the
environment variable \code{DATACOMMONS_API_KEY}.}

\item{base_url}{The base URL of the Data Commons API. Defaults to the public
endpoint. For custom deployments, it must end with "/core/api/v2/".}

\item{return_type}{Return format: either \code{"list"} (parsed R object) or
\code{"json"} (JSON string).}
}
\value{
A list (if \code{return_type = "list"}) or JSON string (if
\code{return_type = "json"}) containing all available statistical variables.
}
\description{
A convenience wrapper around \code{\link[=dc_get_node]{dc_get_node()}} to retrieve all available
statistical variables in Data Commons. This is equivalent to calling
\code{\link[=dc_get_node]{dc_get_node()}} with \code{nodes = "StatisticalVariable"} and
\code{expression = "<-typeOf"}.
}
\examples{
\dontshow{if (dc_has_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get all statistical variables
statistical_vars <- dc_get_statistical_variables()
\dontshow{\}) # examplesIf}
}
