% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataMaid-package.R
\docType{data}
\name{testData}
\alias{testData}
\title{Extended example data to test the features of dataMaid}
\format{
A data frame with 15 rows and 14 variables.
\describe{
   \item{charVar}{A character vector with a single missing observation.}
   \item{factorVar}{A factor vector with a miscoded missing observation, \code{999}.}
   \item{numVar}{A numeric vector}
   \item{intVar}{An integer vector}
   \item{boolVar}{A logical vector with three missing observations.}
   \item{keyVar}{A character vector with unique codes for each observation.}
   \item{emptyVar}{A numeric vector where all entries are identical.}
   \item{numOutlierVar}{A numeric vector with a possible outlier (\code{100}).}
   \item{smartNumVar}{A numeric vector that takes only two different values.}
   \item{cprVar}{A character vector with levels in the format of Danish CPR numbers
   (social security numbers).}
   \item{cprKeyVar}{A character vector with levels in the format of Danish CPR numbers
   (social security numbers) with unique levels for each observation.}
   \item{miscodedMissingVar}{A character vector with levels corresponding to
   various miscoded (non-\code{NA}) misssing codes.}
   \item{misclassifiedNumVar}{A misclassified factor variable, where every level
   is a number and a many (12) different levels are in use.}
   \item{dateVar}{A Date vector.}
   \item{labelledVar}{A labelled vector with two missing observations.}
}
}
\source{
Artificial data
}
\usage{
testData
}
\description{
A dataset of constructed data used as test bed when using \code{dataMaid} for identifying
potential errors in a dataset.
}
\examples{
data(testData)

}
\keyword{datasets}
