% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_smoothing.R
\name{smoothing}
\alias{smoothing}
\title{Smoothing (binning/quantization)}
\usage{
smoothing(n)
}
\arguments{
\item{n}{number of bins}
}
\value{
returns an object of class \code{smoothing}
}
\description{
Family of smoothing methods that reduce noise by replacing values with the mean of a bin/cluster.
Supported strategies: equal‑interval bins, equal‑frequency (quantile) bins, and clustering‑based bins (k‑means).
}
\details{
The smoothing level is controlled by \code{n} (number of bins/levels). The helper \code{tune()} can choose
an \code{n} by locating the elbow (maximum curvature) of the MSE curve across candidates. After \code{fit()},
values are mapped to bin means via \code{transform()}.
}
\examples{
data(iris)
obj <- smoothing_inter(n = 2)
obj <- fit(obj, iris$Sepal.Length)
sl.bi <- transform(obj, iris$Sepal.Length)
table(sl.bi)
obj$interval

entro <- evaluate(obj, as.factor(names(sl.bi)), iris$Species)
entro$entropy
}
