% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml.R
\name{make_hocr}
\alias{make_hocr}
\title{Make hOCR file}
\usage{
make_hocr(type, output, outfile_name = "out.hocr", dir = getwd())
}
\arguments{
\item{type}{one of "sync" or "async" depending on
the function used to process the original document.}

\item{output}{either a HTTP response object (from \code{dai_sync()}) or
the path to a JSON file (from \code{dai_async}).}

\item{outfile_name}{a string with the desired filename. Must end with
either \code{.hocr}, \code{.html}, or \code{.xml}.}

\item{dir}{a string with the path to the desired output directory.}
}
\value{
no return value, called for side effects.
}
\description{
Creates a hOCR file from Document AI output.
}
\details{
hOCR is an open standard of data representation for formatted
text obtained from optical character recognition. It can be used to
generate searchable PDFs and many other things. This function generates
a file compliant with the official hOCR specification
(https://github.com/kba/hocr-spec) complete with token-level confidence
scores. It also works with non-latin scripts and right-to-left languages.
}
