% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{calc_basic_stats}
\alias{calc_basic_stats}
\title{Calculate Basic Statistics for Response Times or Probability Densities}
\usage{
calc_basic_stats(
  pdf_u = NULL,
  pdf_l = NULL,
  rts_u = NULL,
  rts_l = NULL,
  one_cond,
  b_coding,
  t_vec = NULL,
  dt = NULL,
  skip_if_contr_low = NULL
)
}
\arguments{
\item{pdf_u, pdf_l}{numeric, vectors of probability density values for the
upper and lower boundaries.}

\item{rts_u, rts_l}{numeric, vectors of response times for the upper and lower
boundaries.}

\item{one_cond}{character, a label for the condition.}

\item{b_coding}{list, used for accessing the upper boundary label, determines
the corresponding column of the returned data.frame (e.g., P_\code{corr}).}

\item{t_vec}{numeric vector, containing the time points corresponding to the
probability density values.}

\item{dt}{a single numeric, providing the step size in \code{t_vec}.}

\item{skip_if_contr_low}{a single numeric, threshold below which probability
densities are ignored (default is obtained from
\code{\link[=drift_dm_skip_if_contr_low]{drift_dm_skip_if_contr_low()}}).}
}
\value{
A \link{data.frame} with columns:
\itemize{
\item \code{Source}: Indicates whether the statistics refer to observed (\code{obs}) or
predicted (\code{pred}) data.
\item \code{Cond}: A condition label.
\item \verb{Mean_<u_label>}: Mean response time for the upper boundary.
\item \verb{Mean_<l_label>}: Mean response time for the lower boundary.
\item \verb{P_<u_label>}: Proportion of upper-boundary responses.
}
}
\description{
Function that calls the underlying functions
\link{calc_basic_stats_obs} and \link{calc_basic_stats_pred}.
Handles input checks and data wrangling.
}
\details{
\itemize{
\item If \code{pdf_u} and \code{pdf_l} are provided, the function computes statistics for
the probability densities.
\item If \code{rts_u} and \code{rts_l} are provided, the function computes statistics for
the observed RTs.
\item If both sets of inputs are provided, both types of statistics are computed
and returned.
}
}
\seealso{
\link{calc_basic_stats_obs}, \link{calc_basic_stats_pred},
\link{new_stats_dm}
}
\keyword{internal}
