% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize.R
\name{run_analyses}
\alias{run_analyses}
\title{run_analyses}
\usage{
run_analyses(
  DATA,
  THETAs = NULL,
  upKAPPA,
  gTHRES = 0.1,
  COPULAS,
  param_grid,
  vec_time,
  ncores = 1,
  max_iter = 200,
  verb,
  PLOT
)
}
\arguments{
\item{DATA}{A data.frame containing column names 
\code{time} (in years),
\code{delta} (event indicator), 
\code{log_dens_t2} (log-transformed population-based density), and 
\code{log_cdf_t2} (log-transformed population-based cumulative density).}

\item{THETAs}{A vector of theta values to explore and optimize over.}

\item{upKAPPA}{An integer value taking values 0 or 1. If set 
to 1, the exponentiated Weibull distribution is assumed. Otherwise,
the Weibull distribution is assumed and optimized over. If
undefined, the optimization will search over both distributions.}

\item{gTHRES}{A numeric threshold on the L2 norm of 
the gradient evaluated at the MLE.}

\item{COPULAS}{If undefined, will optimize over all copulas. 
Otherwise set to 'Independent', 'Clayton' or 'Gumbel'}

\item{param_grid}{Vector of values spanning possible 
log(alpha1), log(lambda1), log(kappa1), unconstrained 
theta parameters}

\item{vec_time}{Vector of times in years to calculate predicted survival.}

\item{ncores}{A positive integer for the number of threads to evaluate 
log-likelihoods across the parameter grid.}

\item{max_iter}{Maximum Newton Raphson and Gradient Descent iterations
to set.}

\item{verb}{Boolean value to display verbose information or not}

\item{PLOT}{A logical variable, set to \code{TRUE} by default to
show the two-dimensional heatmap of the profile likelihood if 
\code{verb = TRUE}.}
}
\value{
Returns a parsable list of results per successfully optimized configuration of copula and density with accompanying net survival predictions, survival confidence intervals, maximum likelihood estimates, MLE confidence intervals (constrained and unconstrained), Bayesian Information Criteria for model selection, and extra statistical metrics to confirm convergence.
}
\description{
This function performs a full analysis of 
an inputted dataframe. The user may specify one of two 
copulas, a \code{theta} value, a parametric grid to 
search over, and a vector of times for predicting survival.
}
