% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{po_line}
\alias{po_line}
\title{Line}
\usage{
po_line(d3po, ..., data = NULL, inherit_daes = TRUE)
}
\arguments{
\item{d3po}{Either the output of \code{\link[=d3po]{d3po()}} or \code{\link[=d3po_proxy]{d3po_proxy()}}.}

\item{...}{Aesthetics, see \code{\link[=daes]{daes()}}.}

\item{data}{Any dataset to use for plot, overrides data passed
to \code{\link[=d3po]{d3po()}}.}

\item{inherit_daes}{Whether to inherit aesthetics previous specified.}
}
\value{
an 'htmlwidgets' object with the desired interactive plot
}
\description{
Plot an line chart.
}
\examples{
if (interactive()) {
  trade_by_continent <- d3po::trade
  trade_by_continent <- aggregate(
    trade ~ year + reporter_continent,
    data = trade_by_continent,
    FUN = sum
  )

  # Assign colors to continents
  # my_pal <- tintin::tintin_pal(option = "The Broken Ear")(7)
  # [1] "#749972" "#7EA691" "#8EBCC5" "#9DB457" "#A8C17F" "#BBCC4D" "#C7D88F"

  my_pal <- c("#749972", "#7EA691", "#8EBCC5", "#9DB457", "#A8C17F", "#BBCC4D", "#C7D88F")

  names(my_pal) <- c(
    "Africa", "Antarctica", "Asia",
    "Europe", "North America", "Oceania", "South America"
  )

  d3po(trade_by_continent, width = 800, height = 600) \%>\%
    po_line(daes(x = year, y = trade, group = reporter_continent, color = my_pal)) \%>\%
    po_labels(
      x = "Year",
      y = "Trade (USD billion)",
      title = "Trade Distribution by Reporter Continent in 2019 and 2023"
    )
}
}
