% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{po_donut}
\alias{po_donut}
\title{Donut}
\usage{
po_donut(d3po, ..., data = NULL, inherit_daes = TRUE)
}
\arguments{
\item{d3po}{Either the output of \code{\link[=d3po]{d3po()}} or \code{\link[=d3po_proxy]{d3po_proxy()}}.}

\item{...}{Aesthetics, see \code{\link[=daes]{daes()}}.}

\item{data}{Any dataset to use for plot, overrides data passed
to \code{\link[=d3po]{d3po()}}.}

\item{inherit_daes}{Whether to inherit aesthetics previous specified.}
}
\value{
an 'htmlwidgets' object with the desired interactive plot
}
\description{
Plot a donut
}
\examples{
if (interactive()) {
  trade_by_continent <- d3po::trade[d3po::trade$year == 2023L, ]
  trade_by_continent <- aggregate(
    trade ~ reporter_continent,
    data = d3po::trade,
    FUN = sum
  )

  # Assign colors to continents
  # my_pal <- tintin::tintin_pal(option = "The Black Island")(7)
  # [1] "#2D5992" "#478CB3" "#6D92A0" "#727786" "#7D5164" "#9D4649" "#AA866C"

  my_pal <- c("#2D5992", "#478CB3", "#6D92A0", "#727786", "#7D5164", "#9D4649", "#AA866C")

  names(my_pal) <- c(
    "Africa", "Antarctica", "Asia",
    "Europe", "North America", "Oceania", "South America"
  )

  trade_by_continent$color <- my_pal[trade_by_continent$reporter_continent]

  d3po(trade_by_continent, width = 800, height = 600) \%>\%
    po_donut(daes(size = trade, group = reporter_continent, inner_radius = 0.3, color = color)) \%>\%
    po_labels(title = "Trade Share by Reporter Continent in 2023")
}
}
