% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_circ_hist}
\alias{plot_circ_hist}
\title{Circular Histogram of Turn Angles}
\usage{
plot_circ_hist(theta, nbars = 20)
}
\arguments{
\item{theta}{\link[base]{numeric} \link[base]{vector} of angles
(measurements of a circular variable) or "circular" component of pseudo-observations.
They must be on the half-circle, i.e. theta must be in \eqn{[-\pi, \pi)}.}

\item{nbars}{\link[base]{numeric} \link[base]{integer}, the number of bins (bars)
in the histogram.}
}
\value{
A '\code{\link[ggplot2]{ggplot}}' object.
}
\description{
This function produces a circular histogram of turn angles, i.e. angles
on the the half-circle between -pi and pi.
}
\examples{
set.seed(123)

theta <- cylcop::rvonmisesmix(n = 100,
  mu = c(0, pi),
  kappa = c(5, 2),
  prop = c(4, 2)
)
plot1 <- plot_circ_hist(theta)

}
\references{
\insertRef{Hodelmethod}{cylcop}
}
\seealso{
\code{\link{plot_joint_scat}()}.
}
