% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequences.R
\name{rev_comp}
\alias{rev_comp}
\title{Generate reverse complement sequences}
\usage{
rev_comp(seqs)
}
\arguments{
\item{seqs}{Input DNA sequences as a DNAStringSet object, or a named vector 
of sequences that can be coerced to DNAStringSet.}
}
\value{
A DNAStringSet object containing the reverse complemented sequences.
}
\description{
\code{rev_comp} generates the reverse complement of input DNA sequences. 
This is commonly used for analyzing complementary strands or anticodon sequences.
}
\examples{
# Reverse complement of codons
rev_comp(Biostrings::DNAStringSet(c('TAA', 'TAG')))

}
