% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{codon_diff}
\alias{codon_diff}
\title{Differential codon usage analysis}
\usage{
codon_diff(seqs1, seqs2, codon_table = get_codon_table())
}
\arguments{
\item{seqs1}{DNAStringSet, or an object that can be coerced to a DNAStringSet}

\item{seqs2}{DNAStringSet, or an object that can be coerced to a DNAStringSet}

\item{codon_table}{a table of genetic code derived from \code{get_codon_table} or
\code{create_codon_table}.}
}
\value{
a data.table of the differential codon usage analysis. Global tests examine wthether a codon
  is used differently relative to all the other codons. Family tests examine whether a codon is used
  differently relative to other codons that encode the same amino acid. Subfamily tests examine whether
  a codon is used differently relative to other synonymous codons that share the same first two nucleotides.
  Odds ratio > 1 suggests a codon is used at higher frequency in \code{seqs1} than in \code{seqs2}.
}
\description{
\code{codon_diff} takes two set of coding sequences and
perform differential codon usage analysis.
}
\examples{
yeast_exp_sorted <- yeast_exp[order(yeast_exp$fpkm),]
seqs1 <- yeast_cds[names(yeast_cds) \%in\% head(yeast_exp_sorted$gene_id, 1000)]
seqs2 <- yeast_cds[names(yeast_cds) \%in\% tail(yeast_exp_sorted$gene_id, 1000)]
cudiff <- codon_diff(seqs1, seqs2)

}
