% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cto_form_data.R
\name{cto_form_data}
\alias{cto_form_data}
\title{Download and Tidy SurveyCTO Form Data}
\usage{
cto_form_data(
  form_id,
  private_key = NULL,
  start_date = as.POSIXct("2000-01-01"),
  status = c("approved", "rejected", "pending"),
  tidy = TRUE
)
}
\arguments{
\item{form_id}{A string specifying the SurveyCTO form ID.}

\item{private_key}{An optional path to a \code{.pem} private key file. Required
if the form is encrypted.}

\item{start_date}{A POSIXct timestamp. Only submissions received after
this date/time are requested. Defaults to \code{"2000-01-01"}.}

\item{status}{A character vector of submission statuses to include.
Must be a subset of \code{"approved"}, \code{"rejected"}, and \code{"pending"}.
Defaults to all three.}

\item{tidy}{Logical; if \code{TRUE}, attempts to clean and restructure the raw
SurveyCTO output using the XLSForm definition.}
}
\value{
A \code{data.frame} containing the downloaded submissions.

If \code{tidy = FALSE}, the raw parsed JSON response is returned.
If \code{tidy = TRUE}, a cleaned version with standardized column types and
ordering is returned.

Returns an empty \code{data.frame} when no submissions are available.
}
\description{
Downloads submission data from a SurveyCTO server in wide JSON format.
Encrypted forms are supported via a private key. When \code{tidy = TRUE}
(default), the function uses the form's XLSForm definition to convert
variables to appropriate R types, drop structural fields, and organize
columns for analysis.
}
\details{
When \code{tidy = TRUE}, the function performs several common post-processing
steps:

\itemize{
\item \strong{Type conversion:} Converts numeric, date, and datetime fields
to native R types based on question types in the XLSForm.
\item \strong{Structural cleanup:} Removes layout-only fields such as notes,
group markers, and repeat delimiters.
\item \strong{Column ordering:} Places key submission metadata (for example,
completion and submission dates) first, followed by survey variables
in form order.
\item \strong{Media fields:} Strips URLs from image, audio, and video fields,
leaving only the filename.
\item \strong{Geopoints:} Splits geopoint variables into four columns with
\verb{_latitude}, \verb{_longitude}, \verb{_altitude}, and \verb{_accuracy} suffixes when
not already present.
}
}
\examples{
\dontrun{
# Download raw submissions
raw <- cto_form_data("my_form_id", tidy = FALSE)

# Download and tidy encrypted data
clean <- cto_form_data("my_form_id", private_key = "keys/my_key.pem")
}
}
\seealso{
Other Form Management Functions: 
\code{\link{cto_form_attachment}()},
\code{\link{cto_form_data_attachment}()},
\code{\link{cto_form_dofile}()},
\code{\link{cto_form_languages}()},
\code{\link{cto_form_metadata}()}
}
\concept{Form Management Functions}
