% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.ct.R
\name{plot.mds.ct}
\alias{plot.mds.ct}
\title{Plot an mds.ct object}
\usage{
\method{plot}{mds.ct}(
  x,
  npoints = 500,
  cols = viridis(50),
  title = "",
  size.axes = 11,
  samescale = TRUE,
  coords = 1:2,
  GOF.method = 1,
  digits = 1,
  ...
)
}
\arguments{
\item{x}{an object of class "\code{\link{mds.ct}}"}

\item{npoints}{number of time points (equally spaced along the range of times) 
at which to plot the coordinates}

\item{cols}{color scheme; viridis(50) by default}

\item{title}{plot title}

\item{size.axes}{size of axis titles}

\item{samescale}{logical: Should the coordinates be plotted on the same scale?}

\item{coords}{which two principal coordinates to plot (default is 1:2)}

\item{GOF.method}{method to use for computing percent dissimilarity explained
(see argument \code{GOF} of \code{\link{cmdscale}})}

\item{digits}{number of digits to display for percent dissimilarity explained}

\item{...}{other arguments, passed to \code{\link[ggplot2]{theme}}}
}
\value{
None; just produces a plot.
}
\description{
Plots a curve representing of two continuous-time principal coordinates 
produced by \code{\link{mds.ct}}.
}
\examples{
# see example for mds.ct

}
