% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccor.R
\name{ccor}
\alias{ccor}
\title{Curve correlation}
\usage{
ccor(y, time, curve = NULL, k = 15, min.overlap = 0, min.n = 8)
}
\arguments{
\item{y}{either a vector or a two-column matrix, without missing values; see Details}

\item{time}{a vector of time points}

\item{curve}{curve indicator; see Details}

\item{k}{number of B-spline basis functions}

\item{min.overlap}{minimum overlap of the two curves' time ranges}

\item{min.n}{minimum number of observations per curve}
}
\value{
A list with components
\item{y,time }{the supplied \code{y} and \code{time}}
\item{mod1,mod2 }{models for the two curves, outputted by \code{\link[mgcv]{gam}}}
\item{fd1,fd2 }{functional data objects (see \code{\link[fda]{fd}}) for the two curves}
\item{estcor }{estimated curve correlation}
}
\description{
Inputs raw data representing two curves, applies penalized B-spline
smoothing to the two curves, and computes the curve correlation between
them via a call to \code{\link{cor.ct}}.
}
\details{
If \code{y} is a two-column matrix, the two curves are observed at the time points given by
\code{time}; in this case \code{length(time)} must equal \code{nrow(y)}, and \code{curve} is
ignored. If \code{y} is a vector, it must have the same length as both \code{time} and \code{curve}.
In this case \code{y} contains the observations on both curves, while elements of \code{time} and \code{curve}
identify the observation time and the curve being observed, respectively.
}
\examples{

# see example for ccor_posim

}
\seealso{
\code{\link{cor.ct}}, \code{\link[mgcv]{b.spline}}
}
\author{
Philip Tzvi Reiss <reiss@stat.haifa.ac.il>, Noemi Foa, Dror Arbiv and Biplab Paul <paul.biplab497@gmail.com>
}
