% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overall_status_lengths.R
\name{overall_status_lengths}
\alias{overall_status_lengths}
\title{Interpret downloaded version histories to determine how long in
days a trial had any given overall status}
\usage{
overall_status_lengths(
  historical_versions,
  start_date = NA,
  end_date = NA,
  carry_forward_last_status = TRUE
)
}
\arguments{
\item{historical_versions}{A data frame of the type produced by
\code{clinicaltrials_gov_download()} or
\code{clinicaltrials_gov_dates()}. Must include a row for every
historical version, with the \code{nctid} column specifying the
clinical trial registry entry, the \code{overall_status} column
indicating the status of the trial, and the \code{version_date}
column indicating the date on which the registry entry was
updated. Other columns optional.}

\item{start_date}{A date or character string in YYYY-MM-DD format
specifying a date. If specified, only the length of time that
is after the given start date will be counted.}

\item{end_date}{A date or character string in YYYY-MM-DD format
specifying a date. If specified, only the length of time that
is before the given end date will be counted.}

\item{carry_forward_last_status}{Boolean TRUE or FALSE.}
}
\value{
A data frame with two columns: \code{nctid}, which contains all
the distinct NCT numbers from the historical_versions data
frame provided, and \code{days}, which contains the number of
}
\description{
This function takes a data frame of the type produced by
\code{clinicaltrials_gov_download()} or \code{clinicaltrials_gov_dates()} and
interprets it to determine, for each clinical trial registry entry,
how many days were spent in each overall status (e.g. "RECRUITING",
"ACTIVE, NOT RECRUITING", etc.); upper and lower date bounds can
also be applied, to allow for returning only those dates that fall
within a time range of interest.
}
