% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctablerseh.R
\name{ctablerseh}
\alias{ctablerseh}
\title{ctablerseh}
\usage{
ctablerseh(
  numerator,
  denominator,
  disaggregation,
  survey.design,
  survey.data,
  survey.type
)
}
\arguments{
\item{numerator}{is a variable that contains the numerator value or main value of the observation, the estimated value of which will then be calculated, either in the form of a proportion, ratio or average.}

\item{denominator}{is a variable that contains the denominator or divisor value which is usually all observations for proportion cases, or observations with different conditions for ratio cases, or is given the NA value if you only want to calculate the average.}

\item{disaggregation}{is a variable that contains the grouping code for each observation, which can be the smallest group such as district, province or if you want to produce one aggregate estimate value, you can use the same grouping code for all observations.}

\item{survey.design}{is a parameter that contains the survey design created with the "svydesign" function from the "survey" package.}

\item{survey.data}{is the data used in calculating the estimated survey results.}

\item{survey.type}{is a parameter that contains the survey type options, namely proportion (output in percentage form) by selecting "prop", or ratio (output in percentage form) by selecting "ratio" or average by selecting "mean".}
}
\value{
This function returns a dataframe containing the estimated value, standard error, relative standard error, confidence interval, number of samples, and the population represented.
}
\description{
Processes survey data and displays the estimation results along with the relative standard error in the form of a table that includes the number of samples with a t-distribution approach to produce confidence intervals as in SPSS.
}
\examples{
\dontshow{if (requireNamespace("survey", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
susenas.design = survey::svydesign(id=~psu, strata=~strata, data = datex, weights=~FWT)
ctablerseh(numerator = INDI, denominator = denom, disaggregation = R101,
survey.design = susenas.design, survey.data = datex, survey.type = "prop")
\dontshow{\}) # examplesIf}
}
