% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfcif.R
\name{readSF_CIF}
\alias{readSF_CIF}
\title{Reads and output an CIF file}
\usage{
readSF_CIF(filename, message = FALSE)
}
\arguments{
\item{filename}{A character string. The path to a valid CIF file.}

\item{message}{A logical variable. If TRUE (default) the function prints
a message highlighting what is included in the cif file.}
}
\value{
A named list. Each name correspond to a valid field in the SF cif.
}
\description{
Reads and output an CIF file
}
\examples{
datadir <- system.file("extdata",package="cry")
filename <- file.path(datadir,"1dei-sf.cif")
lCIF <- readSF_CIF(filename)
print(names(lCIF))
print(lCIF$INTRO$CELL)
print(lCIF$INTRO$HALL)
print(lCIF$INTRO$HM)
print(lCIF$REFL)
}
