% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reflections.R
\name{change_COLSRC}
\alias{change_COLSRC}
\title{Change COLSRC date and time stamp}
\usage{
change_COLSRC(hdr)
}
\arguments{
\item{hdr}{A data frame. The \code{COLSRC} data frame included
in the \code{header} component of the named list
obtained with \code{\link{readMTZ}} or
\code{\link{readMTZHeader}}.}
}
\value{
The \code{hdr} input data frame with the \code{created}
        column of the \code{COLSRC} data frame changed to
        display the current date and time.
}
\description{
Function to update the \code{created} column of the data
frame \code{COLSRC} with current date and time.
}
\details{
The COLSRC data frame of an MTZ header has a column called
\code{created} which displays the date and time at which the
MTZ file data columns were created. When writing out a
modified list obtained from reading an MTZ file, one might
want to change the \code{created} column with the current
date and time. Other specific types of change can be operated
by handling the \code{COLSRC} data frame in an *ad hoc* manner.
}
\examples{
# Read a sample MTZ file
datadir <- system.file("extdata",package="cry")
filename <- file.path(datadir,"1dei_phases.mtz")
lMTZ <- readMTZ(filename)

# Original COLSRC
print(lMTZ$header$COLSRC)

# Update date and time stamp
lMTZ$header <- change_COLSRC(lMTZ$header)

# New COLSRC
print(lMTZ$header$COLSRC)

}
