\name{NEWS}
\alias{NEWS}

\title{News for Package \pkg{crrstep}}

\section{Changes in version 2025.1.0}{
  \itemize{
    \item Major rewrite to properly handle complex formula terms including:
    \itemize{
      \item Factor variables with multiple levels
      \item Interaction terms (e.g., \code{x1:x2}, \code{x1:factor})
      \item Polynomial terms (e.g., \code{I(x^2)})
      \item Complex interactions with polynomials (e.g., \code{I(x^2):factor})
      \item Log transformations with interactions (e.g., \code{log(x):factor})
      \item Three-way and higher-order interactions
    }
    \item Fixed bug where null model returned incorrect log-likelihood. Previously, when the null model was selected, the function returned the log-likelihood of the last non-null model instead of the actual null model log-likelihood (\code{loglik.null}).
    \item Eliminated deprecation warning related to \code{formula.character()} for formulas with length > 1.
    \item Improved term handling using the \code{assign} attribute from \code{model.matrix()} to correctly identify which columns belong to which terms.
    \item Added helper functions for safer formula manipulation:
    \itemize{
      \item \code{safe_as_formula()}: Safely converts various inputs to formula objects
      \item \code{safe_drop_term()}: Drops terms by reconstructing formula from term labels
      \item \code{safe_add_term()}: Adds terms by reconstructing formula string
    }
    \item Replaced regex-based column matching with proper \code{assign} attribute tracking, fixing issues where variable names contained other variable names as substrings.
    \item Added explicit namespace prefixes (\code{stats::}, \code{cmprsk::}) for CRAN compliance.
  }
}

\section{Changes in version 2015-2.1}{
  \itemize{
    \item Corrected a bug in backward selection procedure in how \code{scope.min} was checked to terminate the selection procedure.
    \item Added checks to make sure that \code{scope.min} formula input is correct.
    \item Simplified how standard error was computed.
    \item Fixed a bug related to outputting results in forward selection.
  }
}

\section{Changes in version 2014-07.16}{
  \itemize{
    \item Corrected a bug in backward selection procedure when one variable name is contained in another variable name (e.g., "Mitosis" and "AtyMitosis").
    \item Corrected a bug in forward selection procedure when an \code{as.factor()} variable is to be added to the model.
  }
}

