% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{validate_batch}
\alias{validate_batch}
\title{Internal: validate and normalize a batch of methods}
\usage{
validate_batch(methods, default_agg_panels, default_agg_repeats)
}
\arguments{
\item{methods}{A list of method specifications.}

\item{default_agg_panels}{Default aggregation function for panels
(used when a method does not provide \code{aggregate_panels}).
Must be a function.}

\item{default_agg_repeats}{Default aggregation function for
repetitions (used when a method does not provide
\code{aggregate_repeats}). Must be a function.}
}
\value{
A named list of fully validated and normalized methods.
}
\description{
Standardizes a list of method specifications:
\itemize{
\item ensures every method has a name,
\item checks and sets \code{mode} and \code{fold_allocation},
\item fills in per-method aggregation functions from global defaults,
\item calls \code{validate_method()} on each method.
}
}
\details{
This is the entry point used by \code{\link{crossfit_multi}} to
validate user-specified methods. It is not intended for direct use by
end users.
}
\keyword{internal}
