% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{FBICriminal_tbl_df}
\alias{FBICriminal_tbl_df}
\title{FBI Criminal Background Check System}
\format{
A tibble with 11,648 observations and 35 variables:
\describe{
  \item{state}{State where the data was recorded (character).}
  \item{year}{Year of the observation (integer).}
  \item{month}{Month of the observation (character).}
  \item{month.num}{Numeric representation of the month (integer).}
  \item{population}{Population of the state (integer).}
  \item{guns_per_thousand}{Number of guns per 1,000 people (numeric).}
  \item{guns_sold}{Total guns sold (integer).}
  \item{multiplier}{Adjustments for sales data (numeric).}
  \item{instore_purchases}{Number of in-store purchases (integer).}
  \item{permit}{Number of gun permits issued (integer).}
  \item{permit_recheck}{Flag for permit recheck status (character).}
  \item{handgun}{Number of handguns sold (integer).}
  \item{longgun}{Number of long guns sold (integer).}
  \item{other}{Number of other types of firearms sold (integer).}
  \item{multiple}{Number of multiple gun purchases (integer).}
  \item{multiple_corrected}{Corrected count of multiple purchases (integer).}
  \item{admin}{Administrative checks conducted (integer).}
  \item{prepawn_handgun}{Number of prepawned handguns (integer).}
  \item{prepawn_longgun}{Number of prepawned long guns (integer).}
  \item{prepawn_other}{Number of prepawned other firearms (integer).}
  \item{redemption_handgun}{Number of redeemed handguns (integer).}
  \item{redemption_longgun}{Number of redeemed long guns (integer).}
  \item{redemption_other}{Number of redeemed other firearms (integer).}
  \item{returned_handgun}{Number of returned handguns (integer).}
  \item{returned_longgun}{Number of returned long guns (integer).}
  \item{returned_other}{Number of returned other firearms (integer).}
  \item{rental_handgun}{Number of handguns rented (integer).}
  \item{rental_longgun}{Number of long guns rented (integer).}
  \item{private_handgun}{Number of privately sold handguns (integer).}
  \item{private_longgun}{Number of privately sold long guns (integer).}
  \item{private_other}{Number of privately sold other firearms (integer).}
  \item{privatereturn_handgun}{Number of privately returned handguns (integer).}
  \item{privatereturn_longgun}{Number of privately returned long guns (integer).}
  \item{privatereturn_other}{Number of privately returned other firearms (integer).}
  \item{totals}{Total checks conducted (integer).}
}
}
\source{
FBI's National Instant Criminal Background Check System (NICS).
}
\usage{
data(FBICriminal_tbl_df)
}
\description{
This dataset contains detailed data from the FBI's National Instant Criminal Background Check System (NICS)
on firearm background checks across U.S. states. It includes monthly data on gun sales, population statistics,
and various firearm-related activities from multiple categories.
}
\details{
The dataset name has been changed to 'FBICriminal_tbl_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the crimedatasets package and assists users
in identifying its specific characteristics. The suffix 'tbl_df' indicates that the dataset is stored as a tibble,
which is a modern form of a data frame in R. The original content has not been modified in any way.
}
