% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summarize_case}
\alias{summarize_case}
\title{Summarise a financing scenario from ratios and metrics}
\usage{
summarize_case(tag, lev_obj, rat_tbl, maturity)
}
\arguments{
\item{tag}{Character(1). Scenario name ("all_equity", "debt_bullet",
"debt_amort", ...).}

\item{lev_obj}{List. Metrics object (contains irr_equity, npv_equity,
irr_project, npv_project).}

\item{rat_tbl}{data.frame. Ratios table (contains year, dscr, ltv_forward).}

\item{maturity}{Integer(1). Maturity year (must correspond to horizon_years).}
}
\value{
Tibble with columns:
scenario, irr_equity, npv_equity, irr_project, npv_project,
min_dscr, max_ltv_forward.
}
\description{
Builds a one-line summary for a given scenario using:
\itemize{
\item levered / unlevered metrics (IRR / NPV);
\item credit ratios computed by \code{add_credit_ratios()}.
}
}
\details{
\subsection{Canonical rules (maturity = horizon_years)}{

\emph{Maturity is now strictly equal to the investment horizon,
without implicit fallbacks such as min(N, 5).}

As a consequence:
\itemize{
\item \strong{min DSCR} takes the value of the attribute
\code{min_dscr_pre_maturity} if available (set by
\code{add_credit_ratios(ignore_balloon_in_min = TRUE)}).
\item Otherwise, \strong{min DSCR} is the minimum over years 1 ... maturity-1
(all operational years before the balloon repayment).
\item \strong{max forward LTV} is the maximum over years 1 ... maturity,
always explicitly excluding t = 0.
}
}
}
\keyword{internal}
