% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{styles_exit_sensitivity}
\alias{styles_exit_sensitivity}
\title{Exit-yield sensitivity of leveraged equity IRR by style}
\usage{
styles_exit_sensitivity(
  styles,
  delta_bps = c(-50, 0, 50),
  config_dir = system.file("extdata", package = "cre.dcf")
)
}
\arguments{
\item{styles}{Character vector of style identifiers
(e.g. \code{"core"}, \code{"core_plus"}, \code{"value_added"}, \code{"opportunistic"}).}

\item{delta_bps}{Numeric vector of exit-yield spread shocks in basis points,
applied additively to the \code{exit_yield_spread_bps} field of each preset.}

\item{config_dir}{Directory where preset YAML files are stored.
Defaults to the package's \code{inst/extdata} folder.}
}
\value{
A tibble with columns:
\itemize{
\item \code{style} (character),
\item \code{shock_bps} (numeric, the applied spread shock),
\item \code{irr_equity} (numeric, leveraged equity IRR under the shock).
}
}
\description{
For each style, this helper:
\itemize{
\item loads the corresponding YAML preset,
\item perturbs the \code{exit_yield_spread_bps} parameter by a grid of deltas,
\item reruns \code{\link[=run_case]{run_case()}} for each perturbation,
\item collects the leveraged equity IRR.
}
}
\details{
Economically, this approximates how sensitive each style's equity IRR is to
small shifts in the exit_yield, and therefore to terminal_value
risk. Strategies that concentrate value creation at exit (e.g. value_added,
opportunistic) should display stronger IRR reactions to a given shock.
}
