% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiggle.R
\name{sign_changes}
\alias{sign_changes}
\title{Sign Changes}
\usage{
sign_changes(
  object,
  lower = min(object$bknots),
  upper = max(object$bknots),
  n = 1000,
  derivative = 1L,
  ...
)
}
\arguments{
\item{object}{a \code{cpr_cp} object}

\item{lower}{the lower limit of the integral}

\item{upper}{the upper limit of the integral}

\item{n}{number of values to assess the derivative between \code{lower} and
\code{upper}.}

\item{derivative}{integer value denoted first or second derivative}

\item{...}{pass through}
}
\value{
the number of times the sign of the first or second derivative
changes within the specified interval.
}
\description{
Count the number of times the first, or second, derivative of a spline
changes sign.
}
\examples{
xvec <- seq(0, 6, length = 500)

# Define the basis matrix
bmat1 <- bsplines(x = xvec, iknots = c(1, 1.5, 2.3, 4, 4.5))
bmat2 <- bsplines(x = xvec)

# Define the control vertices ordinates
theta1 <- c(1, 0, 3.5, 4.2, 3.7, -0.5, -0.7, 2, 1.5)
theta2 <- c(1, 3.4, -2, 1.7)

# build the two control polygons
cp1 <- cp(bmat1, theta1)
cp2 <- cp(bmat2, theta2)
plot(cp1, cp2, show_cp = FALSE, show_spline = TRUE)

sign_changes(cp1)
sign_changes(cp2)


}
\seealso{
\code{\link{wiggle}}
}
