% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_trace_df.R
\name{test_trace_df}
\alias{test_trace_df}
\alias{test_trace_df.coverage}
\title{Build a traceability matrix that links documented behaviors to unit tests}
\usage{
test_trace_df(x, ...)

\method{test_trace_df}{coverage}(
  x,
  ...,
  pkg = as.package(attr(x, "package")$path),
  aggregate_by = sum
)
}
\arguments{
\item{x}{A package object, name, source code path or coverage result to use
as the bases of tracing tests. Coverage results must have been produced
using \code{options(covr.record_tests = TRUE)}.}

\item{...}{Additional arguments unused}

\item{pkg}{A \code{package} object as produced by \code{as.package}, if a specific
package object is to be used for inspecting the package namespace.}

\item{aggregate_by}{\code{NULL} or a function by which to aggregate recurring hits
\code{counts} and \code{direct} columns from a test to a trace. If \code{NULL}, no
aggregation will be applied. (Default \code{sum})}
}
\value{
A \code{data.frame} of tests and corresponding traces
}
\description{
Intercept unit test coverage reports and process results to link evaluated
functions to the unit tests which trigger their evaluation. In doing so,
we can then link the associated function documentation of each object to
the tests that triggered their evaluation as a way of reusing existing
documentation to generate specifications.
}
