% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srcref_df.R
\name{as.data.frame.list_of_srcref}
\alias{as.data.frame.list_of_srcref}
\title{Coerce a list_of_srcref object to a data.frame}
\usage{
\method{as.data.frame}{list_of_srcref}(
  x,
  ...,
  use.names = TRUE,
  expand.srcref = FALSE,
  row.names = NULL
)
}
\arguments{
\item{x}{A \code{list_of_srcref} object}

\item{...}{Additional arguments unused}

\item{use.names}{A \code{logical} indicating whether the names of \code{x}
should be used to create a \code{name} column.}

\item{expand.srcref}{A \code{logical} indicating whether to expand the
components of \code{srcref} objects into separate columns.}

\item{row.names}{\code{NULL} or a single integer or character string
    specifying a column to be used as row names, or a character or
    integer vector giving the row names for the data frame.}
}
\value{
A \code{data.frame} with one record per \code{srcref} and variables:
\describe{
\item{name}{Names of the \code{srcref} objects, passed using the names of
\code{x} if \code{use.names = TRUE}}
\item{srcref}{\code{srcref} objects if \code{expand.srcrefs = FALSE}}
\item{srcfile, line1, byte1, line2, col1, col2, parsed1, parsed2}{The
\code{srcref} file location if it can be determined. If an absolute path
can't be found, only the base file name provided in the \code{srcref} object and
the numeric components of the \code{srcref} objects if \code{expand.srcrefs
  = TRUE}}
}
}
\description{
Coerce a list_of_srcref object to a data.frame
}
\examples{
pkg <- system.file("examplepkg", package = "covtracer")
install.packages(
  pkg,
  type = "source",
  repos = NULL,
  quiet = TRUE,
  INSTALL_opts = "--with-keep.source"
)
as.data.frame(pkg_srcrefs("examplepkg"))
}
