% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian_copula_two_vars.R
\name{gaussian_copula_two_vars}
\alias{gaussian_copula_two_vars}
\title{Generate Gaussian Copula Samples for Two Variables}
\usage{
gaussian_copula_two_vars(n, p)
}
\arguments{
\item{n}{Integer. The number of samples to generate.}

\item{p}{Numeric. The correlation coefficient (\eqn{\rho}) between the two variables.
Must be in the range \code{[-1, 1]}.}
}
\value{
A matrix of size \code{n x 2}, where each row represents a sample,
and each column corresponds to one of the two variables. The values
are uniformly distributed in \code{[0, 1]}.
}
\description{
This function generates samples from a Gaussian copula with two variables,
given the specified correlation coefficient between the variables.
}
\details{
The function internally constructs a correlation matrix for two variables:
\deqn{\rho_matrix = \begin{bmatrix} 1 & p \\ p & 1 \end{bmatrix}}
It then calls \code{generate_gaussian_copula_samples} to generate samples.
}
\examples{
# Example usage:
samples <- gaussian_copula_two_vars(n = 1000, p = 0.7)
head(samples)

}
\seealso{
\code{\link{generate_gaussian_copula_samples}}
}
