% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_blocks.R
\name{matchmaker}
\alias{matchmaker}
\title{Create blocks for stratified matching}
\usage{
matchmaker(
  left,
  right,
  block_type = c("none", "group", "cluster"),
  block_by = NULL,
  block_vars = NULL,
  block_method = "kmeans",
  n_blocks = NULL,
  min_left = 1,
  min_right = 1,
  drop_imbalanced = FALSE,
  imbalance_threshold = Inf,
  return_dropped = TRUE,
  ...
)
}
\arguments{
\item{left}{Data frame of "left" units (e.g., treated, cases)}

\item{right}{Data frame of "right" units (e.g., control, controls)}

\item{block_type}{Type of blocking to use:
\itemize{
\item "none": No blocking (default)
\item "group": Block by existing categorical variable(s)
\item "cluster": Block using clustering algorithm
}}

\item{block_by}{Variable name(s) for grouping (if block_type = "group")}

\item{block_vars}{Variable names for clustering (if block_type = "cluster")}

\item{block_method}{Clustering method (if block_type = "cluster"):
\itemize{
\item "kmeans": K-means clustering
\item "hclust": Hierarchical clustering
}}

\item{n_blocks}{Target number of blocks (for clustering)}

\item{min_left}{Minimum number of left units per block}

\item{min_right}{Minimum number of right units per block}

\item{drop_imbalanced}{Drop blocks with extreme imbalance}

\item{imbalance_threshold}{Maximum allowed |n_left - n_right| / max(n_left, n_right)}

\item{return_dropped}{Include dropped blocks in output}

\item{...}{Additional arguments passed to clustering function}
}
\value{
A list with class "matchmaker_result" containing:
\itemize{
\item \code{left}: Left data frame with block_id column added
\item \code{right}: Right data frame with block_id column added
\item \code{block_summary}: Summary statistics for each block
\item \code{dropped}: Information about dropped blocks (if any)
\item \code{info}: Metadata about blocking process
}
}
\description{
Constructs blocks (strata) for matching, using either grouping variables
or clustering algorithms. Returns the input data frames with block IDs
assigned, along with block summary statistics.
}
\details{
This function does NOT perform matching - it only creates the block structure.
Use \code{\link[=match_couples]{match_couples()}} or \code{\link[=greedy_couples]{greedy_couples()}} to perform matching within blocks.
}
\examples{
# Group blocking
left <- data.frame(id = 1:10, region = rep(c("A", "B"), each = 5), x = rnorm(10))
right <- data.frame(id = 11:20, region = rep(c("A", "B"), each = 5), x = rnorm(10))
blocks <- matchmaker(left, right, block_type = "group", block_by = "region")
print(blocks$block_summary)

# Clustering
blocks <- matchmaker(left, right, block_type = "cluster",
                     block_vars = "x", n_blocks = 3)

}
