% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cossonet.predict.R
\name{cossonet.predict}
\alias{cossonet.predict}
\title{The function \code{cossonet.predict} predicts predictive values for new data based on an object from the \code{cossonet} function.}
\usage{
cossonet.predict(model, testx)
}
\arguments{
\item{model}{The fitted cossonet object.}

\item{testx}{The new data set to be predicted.}
}
\value{
A list of predicted values for the new data set.
}
\description{
The function \code{cossonet.predict} predicts predictive values for new data based on an object from the \code{cossonet} function.
}
\examples{
\donttest{
set.seed(20250101)
tr = data_generation(n = 200, p = 20, SNR = 9, response = "continuous")
tr_x = tr$x
tr_y = tr$y

te = data_generation(n = 1000, p = 20, SNR = 9, response = "continuous")
te_x = te$x
te_y = te$y

# Fit the model
fit = cossonet(tr_x, tr_y, family = 'gaussian', gamma = 0.95, kernel = "spline", scale = TRUE,
      lambda0 = exp(seq(log(2^{-4}), log(2^{0}), length.out = 20)),
      lambda_theta = exp(seq(log(2^{-8}), log(2^{-6}), length.out = 20))
      )

# Predict new dataset
pred = cossonet.predict(fit, te_x)
}
}
