% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copernicus_opendataset.R
\name{copernicus_open_dataset}
\alias{copernicus_open_dataset}
\title{Open dataset from Copernicus Marine without download}
\usage{
copernicus_open_dataset(
  dataset_id,
  variables = NULL,
  start_date = NULL,
  end_date = NULL,
  bbox = NULL,
  depth = NULL,
  dataset_version = NULL,
  username = NULL,
  password = NULL,
  verbose_open = TRUE,
  ...
)
}
\arguments{
\item{dataset_id}{ID of the dataset (exact).}

\item{variables}{Vector or list of variables to open. If NULL, opens all.}

\item{start_date}{Start date (YYYY-MM-DD). Optional.}

\item{end_date}{End date (YYYY-MM-DD). Optional.}

\item{bbox}{Vector of 4 values (xmin, xmax, ymin, ymax) for the region. Optional.}

\item{depth}{Vector of 2 values: minimum and maximum depth. Optional.}

\item{dataset_version}{Dataset version. Optional.}

\item{username}{Copernicus Marine username (optional, will try to get from stored credentials).}

\item{password}{Copernicus Marine password (optional, will try to get from stored credentials).}

\item{verbose_open}{Show detailed messages.}

\item{...}{Other extra arguments passed to the Python function.}
}
\value{
Python xarray.Dataset object, or NULL if it fails.
}
\description{
Opens a dataset directly from Copernicus Marine using open_dataset.
Returns a Python xarray.Dataset object that can be processed in R.
Useful for exploring data without downloading full files.
Uses stored credentials from options/environment variables if available.
}
